// koennte man auch als map machen anstatt mit "at" ?
struct Column {
	1:i32        at,
	2:i32      kind, // Variable Type: GLP_CV, GLP_IV, GLP_BV (continuous, integer, binary)
	3:i32      type, // Bound Type:    GLP_FR, GLP_LO, GLP_UP, GLP_DB, GLP_FX (free, low, up, double bounded, fix)
	4:double  lower,
	5:double  upper
}

// koennte man auch als map machen anstatt mit "at" ?
struct Row {
	1:i32              at,
	2:list<double>   vals,
	3:list<i32>       ids,
	4:i32            type,
	5:double        lower,
	6:double        upper
}

struct Obj {
	1:bool            isMax,
	2:list<double>    coefs,
	3:list<Column>     cols,
	4:list<Row>        rows
}

struct Configurator {
	1:string filename              =  "?",
	2:i32    jobTimeout            =  -1,
	3:i32    K                     =  10,
	4:double factor                =   1.0,
	5:double breadthEndProcent     =  25.0,
	6:double timeoutEndProcent     =  70.0,
	7:i32    farmerTimeout         =  -1,
	8:i32    syncBest              = 200
}

struct Job {
	1:double                 _opt,
	2:list<double>           _fix,
	3:bool                   _end,
	4:double           _bestBound,         // im schlimmsten fall die simplex-loesung des Jobs bei timeout
	5:i32                _timeout,
	6:i32                  _lastK = 0,
	7:list<Column>          _lazy          // zusatzbedingungen
}

enum SolveFlag {
	OK       = 0,
	TIMEOUT  = 1,
	BOUNDERR = 2,
	KILLED   = 3,
	NOSOL    = 4,
	FAIL     = 5
}

struct FarmerInfo {
	1:i32            runWorker,
	2:list<string> runningJobs,
	3:i32            allWorker,
	4:i64             duration,
	5:string              best,
	6:Configurator        conf,
	7:list<i64>           jobs,
	8:list<i64>       timeouts,
	
	9:string        fileformat,
	10:string        direction,
	11:i32                cols,
	12:i32                rows,
	13:i32             notZero,
	14:list<i32>           mem
}

struct SolveResult {
	1:list<Job>  newJobs,
	2:SolveFlag     flag
}

struct UpdateResult {
	1:Job  job,
	2:i32  mem
}

service Remote {
	void          input( 1:Obj data, 2:Configurator conf),
	SolveResult   solve( 1:Job bestJob, 2:Job newJob ),
	void           kill( ),
	UpdateResult  update( 1:Job bestJob )
}

service Monitoring {
	FarmerInfo get()
}
