#ifndef _MYMONITOR_HPP
#define _MYMONITOR_HPP 1

#include <vector>
#include <string>
#include <mutex>
#include "thrift/gen-cpp/Monitoring.h"
#include <thrift/server/TThreadedServer.h>

using namespace ::apache::thrift::server;
using namespace std;

class MonitoringHandler : virtual public MonitoringIf {
public:
	void get(FarmerInfo & _return);
};

class MyMonitor {
private:
	TThreadedServer * _server;
	void srvRoutine();
	
public:
	int _intervall;

	static mutex _farmMu;
	static FarmerInfo _farmInfo;
	
	MyMonitor(int intervallMs, FarmerInfo farmInfo);
	virtual ~MyMonitor();

	void log(
		int runWorker,
		vector<string> runningJobs,
		int & allWorker,
		long long & duration,
		string best,
		Configurator conf,
		vector<long> jobs,
		vector<long> timeouts,
		vector<int> mem
	);
};

#endif
